/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public class ArgumentsTokenizer {
    public static String[] tokenize(String toProcess) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder currentToken = new StringBuilder();
        State state = State.None;
        char[] chars = toProcess.toCharArray();
        block23: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\'': {
                    state = switch (state.ordinal()) {
                        default -> throw new MatchException(null, null);
                        case 0 -> State.QuoteSingle;
                        case 1 -> State.None;
                        case 2 -> {
                            currentToken.append('\'');
                            yield State.QuoteDouble;
                        }
                    };
                    continue block23;
                }
                case '\"': {
                    state = switch (state.ordinal()) {
                        default -> throw new MatchException(null, null);
                        case 0 -> State.QuoteDouble;
                        case 1 -> {
                            currentToken.append('\"');
                            yield State.QuoteSingle;
                        }
                        case 2 -> State.None;
                    };
                    continue block23;
                }
                case '\\': {
                    if (i++ < chars.length) {
                        currentToken.append(switch (chars[i]) {
                            case 'b' -> '\b';
                            case 'f' -> '\f';
                            case 'n' -> '\n';
                            case 'r' -> '\r';
                            case 't' -> '\t';
                            default -> chars[i];
                        });
                        continue block23;
                    }
                    currentToken.append('\\');
                    continue block23;
                }
                case ' ': {
                    if (state == State.None) {
                        tokens.add(currentToken.toString());
                        currentToken = new StringBuilder();
                        continue block23;
                    }
                    currentToken.append(' ');
                    continue block23;
                }
                default: {
                    currentToken.append(chars[i]);
                }
            }
        }
        if (!currentToken.isEmpty()) {
            tokens.add(currentToken.toString());
        }
        return (String[])tokens.toArray(String[]::new);
    }

    public static String join(String[] args) {
        return Arrays.stream(args).map(arg -> {
            if (((String)(arg = ((String)arg).replace("\\", "\\\\").replace("\b", "\\b").replace("\f", "\\f").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t").replace("\"", "\\\""))).contains("\\") || ((String)arg).contains(" ")) {
                arg = "\"" + (String)arg + "\"";
            }
            return arg;
        }).collect(Collectors.joining(" "));
    }

    private static enum State {
        None,
        QuoteSingle,
        QuoteDouble;

    }
}

